
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Runtime.Serialization;
using System.Collections.Specialized;
using System.Threading;
using System.Security.Principal;

#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{

	
	

	[TestFixture]
	public class Common_BaseApplicationException : BaseTest 
	{
		
		private ExceptionManagement.BaseApplicationException _baseAppException;
		private ExceptionManagement.BaseApplicationException _baseAppExceptionMsg;
		private ExceptionManagement.BaseApplicationException _baseAppExceptionInnerExcepMsg;

		private string _testInnerValue = System.DateTime.Now.ToString();
		private string _testValue = System.DateTime.Now.ToString();

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			this._baseAppException = new ExceptionManagement.BaseApplicationException();
			this._baseAppExceptionMsg = new ExceptionManagement.BaseApplicationException(this._testValue);
			ApplicationException expInner = new ApplicationException(this._testInnerValue);
			this._baseAppExceptionInnerExcepMsg = new ExceptionManagement.BaseApplicationException(this._testValue, expInner);
		}
		
		[Test]
		public void Ctor_Blank_Pass()
		{
			Assert.AreEqual(Environment.MachineName, this._baseAppException.MachineName, "MachineName");
			Assert.AreEqual(Thread.CurrentPrincipal.Identity.Name, this._baseAppException.ThreadIdentityName, "ThreadIdentityName");
			Assert.AreEqual(WindowsIdentity.GetCurrent().Name, this._baseAppException.WindowsIdentityName, "WindowsIdentityName");
			Assert.AreEqual(AppDomain.CurrentDomain.FriendlyName, this._baseAppException.AppDomainName, "AppDomainName");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_String_Pass()
		{
			Assert.AreEqual(this._testValue, this._baseAppExceptionMsg.Message);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_String_Fail()
		{
		}

		[Test]
		public void Ctor_String_Exp_Pass()
		{
			Assert.AreEqual(this._testValue, this._baseAppExceptionInnerExcepMsg.Message, "Message");
			Assert.AreEqual(this._testInnerValue, this._baseAppExceptionInnerExcepMsg.InnerException.Message, "InnerMessage");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_String_Exp_Fail()
		{			
		}

		[Test]
		public void GetObjectData_Pass()
		{
			SerializationInfo info = new SerializationInfo(typeof(ExceptionManagement.BaseApplicationException), new System.Runtime.Serialization.FormatterConverter());
			StreamingContext context = new System.Runtime.Serialization.StreamingContext();

			this._baseAppException.GetObjectData(info, context);

			Assert.AreEqual(18, info.MemberCount);
		}
		[Test]
		public void GetObjectData_Fail() 
		{
			SerializationInfo info = new SerializationInfo(typeof(ExceptionManagement.BaseApplicationException), new System.Runtime.Serialization.FormatterConverter());
			info = null;
			StreamingContext context = new System.Runtime.Serialization.StreamingContext();
	
			try
			{
				this._baseAppException.GetObjectData(info, context);
			}
			catch(Exception exp)
			{
				Assert.AreEqual("Object reference not set to an instance of an object.", exp.Message, "Message");
			}
		}

		[Test]
		public void MachineName_Pass()
		{
			Assert.AreEqual(Environment.MachineName, this._baseAppException.MachineName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MachineName_Fail()
		{
		}

		[Test]
		public void CreatedDateTime_Pass()
		{
			Assert.AreEqual(this._baseAppException.CreatedDateTime, this._baseAppException.CreatedDateTime);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void CreatedDateTime_Fail()
		{
		}

		[Test]
		public void AppDomainName_Pass()
		{
			Assert.AreEqual(AppDomain.CurrentDomain.FriendlyName, this._baseAppException.AppDomainName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void AppDomainName_Fail()
		{
		}

		[Test]
		public void ThreadIdentityName_Pass()
		{
			Assert.AreEqual(Thread.CurrentPrincipal.Identity.Name, this._baseAppException.ThreadIdentityName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ThreadIdentityName_Fail()
		{
		}

		[Test]
		public void WindowsIdentityName_Pass()
		{
			Assert.AreEqual(WindowsIdentity.GetCurrent().Name, this._baseAppException.WindowsIdentityName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void WindowsIdentityName_Fail()
		{
		}

		[Test]
		public void AdditionalInformation_Pass()
		{
			Assert.AreEqual(this._baseAppException.AdditionalInformation, this._baseAppException.AdditionalInformation);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void AdditionalInformation_Fail()
		{
		}

	}
}
#endif
